<Query Kind="Program">
  <NuGetReference>Microsoft.CodeAnalysis.CSharp</NuGetReference>
  <Namespace>Microsoft.CodeAnalysis</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp.Syntax</Namespace>
</Query>

void Main()
{
	var tree = CSharpSyntaxTree.ParseText (@"class Test
{
  static void Main()
  {
    if (true)
	  if (true);
  };
}");

	SyntaxNode root = tree.GetRoot();

	var ifCounter = new IfCounter ();
	ifCounter.Visit (root);
	Console.WriteLine ($"Znaleziono {ifCounter.IfCount} poleceń if.");

	root.DescendantNodes().OfType<IfStatementSyntax>().Count().Dump ("Functional equivalent");
}

class IfCounter : CSharpSyntaxWalker
{
	public int IfCount { get; private set; }

	public override void VisitIfStatement (IfStatementSyntax node)
	{
		IfCount++;
		// jeżeli chcesz otrzymać węzeł potomny, wywołaj metodę bazową
		base.VisitIfStatement (node);
	}
}
